local t = Def.ActorFrame{
	-- All the stuff in the background (aside from the background itself).
	Def.ActorFrame {
		OnCommand=function(self)
			self:xy(_screen.cx,THEME:GetMetric("ScreenSelectMusic","MusicWheelY"))
		end,
		
		-- Backing for mostly under the steps display.
		Def.Quad {
			Condition = not GAMESTATE:IsCourseMode(),
			OnCommand=function(self)
				self:y(_screen.cy):vertalign(bottom):diffuse(Color.Black):zoomto(284,(_screen.cy/2)-4)
			end
		},
		
		-- Def.Quad {
			-- OnCommand=function(self)
				-- self:diffuse(LocalBlueColor(0.5)):zoomto(240+8,_screen.h/1.75):y(-20)
			-- end
		-- },
		
		Def.ActorFrame{
		-- Something to hold MORE SONG INFO :) in (credit/origin).
			Def.Quad {
				OnCommand=function(self)
					self:y(-80):diffuse(Color.Alpha(Color.Black,0.8)):zoomto(_screen.w,40)
				end
			},
			
			-- Markers for the origin/credit fielfs.
			Def.BitmapText {
				Font = "Common Large",
				Text = "♫",
				OnCommand=function(self)
					self:xy(196,-92):diffuse(LocalBlueColor(0.5)):zoom(0.75)
				end
			},
			LoadActor("vidicon") .. {
				OnCommand=function(self)
					self:xy(-196,-90):diffuse(LocalBlueColor(0.5)):zoom(0.75)
				end
			},
			
			-- Someting to cap it with.
			LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
				OnCommand=function(self)
					self:y(-100+5):vertalign(bottom):diffuse(LocalBlueColor(1)):zoomto(_screen.w,10):blend(Blend.Add)
				end
			},
		},
		
		-- All of the song info in one place.
		LoadActor("TopPane") .. {
			OnCommand=cmd(y,-114;playcommand,"Set"),
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"),
			SetCommand=function(self)
				local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
				local newY = target and -114 or -78
				if newY ~= self:GetY() then
					self:stoptweening():linear(0.2):y(newY)
				end
			end
		},
		
		-- Extra space for song title here 'cause I don't want it to overlap the lights
		Def.Quad {
			OnCommand=function(self)
				self:diffuse(Color.Alpha(Color.Black,0.8)):zoomto(_screen.w,80):y(85)
			end
		},
		
		-- Main quad...s behind the song wheel.
		Def.Quad {
			OnCommand=function(self)
				self:diffuse(LocalBlueColor(0.25)):zoomto(_screen.w,120)
			end
		},
		-- Nice little shadow detail.
		Def.Quad {
			OnCommand=function(self)
				self:diffuse(Color.Black):zoomto(_screen.w,120):fadetop(0.3):fadebottom(0.3)
			end
		},
		
		
		-- Player stuff now to avoid overlap.
		LoadActor("InfoPane", PLAYER_1) .. {
			-- This won't fit on course select.
			Condition = not GAMESTATE:IsCourseMode(),
			InitCommand=cmd(x,-284/2;y,125;player,PLAYER_1),
			PlayerJoinedMessageCommand=function(self, params)
				if params.Player == PLAYER_1 then
					self:visible(true)
				end
			end,
			PlayerUnjoinedMessageCommand=function(self, params)
				if params.Player == PLAYER_1 then
					self:visible(false)
				end
			end,
			SetCommand=function(self)
				local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
				local newY = target and 125 or 250
				if newY ~= self:GetY() then
					self:stoptweening():linear(0.2):y(newY)
				end
			end,
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"),
		},
		LoadActor("InfoPane", PLAYER_2) .. {
			-- This won't fit on course select.
			Condition = not GAMESTATE:IsCourseMode(),
			InitCommand=cmd(x,284/2;y,125;player,PLAYER_2),
			PlayerJoinedMessageCommand=function(self, params)
				if params.Player == PLAYER_2 then
					self:visible(true)
				end
			end,
			PlayerUnjoinedMessageCommand=function(self, params)
				if params.Player == PLAYER_2 then
					self:visible(false)
				end
			end,
			SetCommand=function(self)
				local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
				local newY = target and 125 or 250
				if newY ~= self:GetY() then
					self:stoptweening():linear(0.2):y(newY)
				end
			end,
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"),
		},
		
		--Player color lights...
		LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
			Condition = not GAMESTATE:IsCourseMode(),
			OnCommand=function(self)
				self:xy(-240+84,125):rotationz(90):horizalign(left):vertalign(bottom):
					zoomto(_screen.h / 3,30):blend(Blend.Add):diffuse(PlayerColor(PLAYER_1))
			end
		},
		LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
			Condition = not GAMESTATE:IsCourseMode(),
			OnCommand=function(self)
				self:xy(240-84,125):rotationz(90):horizalign(left):vertalign(top):
					zoomto(_screen.h / 3,30):blend(Blend.Add):diffuse(PlayerColor(PLAYER_2))
			end
		},
		
		-- ...and more lights around the music wheel and song name display.
		LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
			OnCommand=function(self)
				self:y(-60+10):vertalign(bottom):zoomto(_screen.w*1.3,20):blend(Blend.Add):
					glowramp():effectcolor1(Color.Invisible):effectcolor2(color("#FFFFFF66")):blend(Blend.Add):effectclock("bgm")
			end
		},
		LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
			OnCommand=function(self)
				self:y(60-10):vertalign(top):zoomto(_screen.w*1.3,20):blend(Blend.Add):
					glowramp():effectcolor1(Color.Invisible):effectcolor2(color("#FFFFFF44")):blend(Blend.Add):effectclock("bgm")
			end
		},
		LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
			OnCommand=function(self)
				self:y((40+85)-10):vertalign(top):zoomto(_screen.w*1.3,20):blend(Blend.Add)
			end
		},
	},
	
	
	-- Important stuff.
	Def.ActorFrame {
		OnCommand=function(self)
			self:Center()
		end,
		
		-- "Origin" field display.
		Def.BitmapText {
			Font = "Common Normal",
			InitCommand=function(self)
				self:xy(-_screen.cx+6, -90):zoom(0.35):horizalign(left):strokecolor(Color.Outline):maxwidth((_screen.w/4.5) / 0.3):
					wrapwidthpixels((_screen.w/4.5) / 0.3)
			end,
			SetCommand=function(self)
				local song = GAMESTATE:GetCurrentSong()
				
				if GAMESTATE:IsCourseMode() then
					self:settext("")
				elseif song and song:GetOrigin() ~= "" then
					self:settext(song:GetOrigin())
				else
					self:settext("")
				end
			end,
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set")
		},
		-- "Credit" field display.
		Def.BitmapText {
			Font = "Common Normal",
			InitCommand=function(self)
				self:xy(_screen.cx-6, -90):zoom(0.35):horizalign(right):strokecolor(Color.Outline):maxwidth((_screen.w/4.5) / 0.3):
					wrapwidthpixels((_screen.w/4.5) / 0.3)
			end,
			SetCommand=function(self)
				local song = GAMESTATE:GetCurrentSong()
				
				if GAMESTATE:IsCourseMode() then
					self:settext("")
				elseif song and song:GetCredit() ~= "" then
					self:settext(song:GetCredit())
				else
					self:settext("")
				end
			end,
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set")
		},
		
		-- Song/group folder/whatever the song's wheel's on.
		Def.BitmapText {
			Font = "Common Normal",
			Name="WhateverIsSelectedName",
			InitCommand=function(self)
					self:y(82):maxwidth((_screen.w - 4) / 0.5):wrapwidthpixels((_screen.w - 4) / 0.5):zoom(0.5):strokecolor(Color.Outline)
			end,
			SetCommand=function(self)
				local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
				--SM(ToEnumShortString(SCREENMAN:GetTopScreen():GetChild("MusicWheel"):GetSelectedType()))
				
				if target then
					-- Make this check because the way we'll get our needed strings is
					-- a little different when we're dealing with courses
					if GAMESTATE:IsCourseMode() then
						if target:GetDescription() ~= "" then
							self:settext(target:GetDisplayFullTitle() .. "\n'" .. target:GetDescription() .. "'")
						else
							self:settext(target:GetDisplayFullTitle())
						end
					else
						self:settext(target:FormattedSongTitleAndArtist())
					end
				else
					-- Looks like we'll have to get a little tricky
					local wheelType = ToEnumShortString(SCREENMAN:GetTopScreen():GetChild("MusicWheel"):GetSelectedType())
					local textAppend = wheelType == "Section" and THEME:GetString("ScreenSelectMusic", "Grouping") or ""
					
					local wheelText = SCREENMAN:GetTopScreen():GetChild("MusicWheel"):GetSelectedSection()
					self:settext(wheelType == "Sort" and THEME:GetString("ScreenSelectMusic", "SortMe") or wheelText .. textAppend)
					-- 
					if wheelText == THEME:GetString("MusicWheel","Empty") then
						self:settext(GAMESTATE:IsCourseMode() and THEME:GetString("ScreenSelectMusic", "EmptyCourses") or THEME:GetString("ScreenSelectMusic", "EmptyPreferred"))
					end
				end
			end,
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set")
		}
	}
}

t[#t+1] = LoadFallbackB()

return t